<?php

namespace App\Models\Quizes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quiz extends Model 
{

    protected $table = 'quizes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getInstitution()
    {
        return $this->belongsTo('App\Models\Orgs\Institution');
    }

    public function getUser()
    {
        return $this->belongsTo('App\Models\Orgs\User');
    }

    public function getChallengeElements()
    {
        return $this->hasMany('App\Models\Challenges\ChallengeElement');
    }

    public function getAccreditation()
    {
        return $this->hasOne('App\Models\Accreditation\Accreditation');
    }

    public function getKeywords()
    {
        return $this->belongsToMany('App\Models\Keywords\Keyword', 'quiz_keyword')->withPivot('credits');
    }

    public function getAttendances()
    {
        return $this->hasMany('App\Models\Students\Attandance');
    }

    public function getEpisodeType()
    {
        return $this->belongsTo('App\Models\Involvements\EpisodeType');
    }

    public function getInvolvement()
    {
        return $this->belongsTo('App\Models\Involvements\Involvement');
    }

}